dos33.h
#define MAXFILES 8

#define	READ	0
#define	WRITE	1
#define	RDWRT	2

extern int _DSLOT, _DDRIVE, _DVOLUME;
extern int _SLOT, _DRIVE, _VOLUME;
extern char _NAME[];

struct _params {
char	p_cmd,
		p_sub;
int		p_record,
		p_offset,
		p_range;
char	*p_addr,
		p_return,
		p_unused,
		*p_work,
		*p_tslist,
		*p_data;
};

struct _buffers {
char	b_name[30];
struct _wrkbuf *b_work;
char	*b_tslist,
		*b_data;
struct _buffers *b_next;
};

struct _wrkbuf {
char	w_dcnt,
		w_tst0,
		w_tss0,
		w_cts,
		w_cnt,
		w_pos,
		w_ftr,
		w_fse,
		w_ctr,
		w_cse,
		w_dty,
		w_tsdty,
		w_tstr,
		w_tsse,
		w_drt,
		w_dse,
		*w_dent,
		w_fill1[7];
int		w_record,
		w_offset;
char	w_fill2[8],
		w_ftype,
		w_slot,
		w_drive,
		w_volume,
		w_fill3[4];
};

struct _fil_buf {
		char 	unit,			/* DOS return or device nr | 0x80 */
				flags;			/* r/w flags */
		struct _buffers	*iob;			/* ptr to DOS buffer for file */
	};

extern struct _fil_buf *_fil_tab;

struct _params *_get_paramlist();
struct _buffers *_get_buf();

#define D33_OPEN 1
#define D33_CLOSE 2
#define D33_READ 3
#define D33_WRITE 4
#define D33_DELETE 5
#define D33_CATALOG 6
#define D33_LOCK 7
#define D33_UNLOCK 8
#define D33_RENAME 9
#define D33_POSITION 10
#define D33_INIT 11
#define D33_VERIFY 12
d33root.a65
*:ts=8
*
* Copyright (C) 1982,83,84,85 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

	global	_Top_,2
	global	_mbot_,2
	global	_dev_info_,2
	global	_devinfo_,0
	global	_fil_tab_,2
	global	_filtab_,0
	global	errno_,2

	dseg
	public _DSLOT_
	public _DDRIVE_
	public _DVOLUME_
_DSLOT_	fdb	6	default slot no=6
_DDRIVE_	fcb	1	default drive no=1
_DVOLUME_	fdb	0	default volume no = 0

	global _SLOT_,2
	global _DRIVE_,2
	global _VOLUME_,2

	global _NAME_,30

	dseg
	public	MEMRY
MEMRY	rmb	2
	public	_Stksiz_
_Stksiz_
	fdb	$0800		;default stack size is 2K
	public	_End_
_End_
	fdb	$0001		;force into inited data space

	public	_main_
_main_	fdb	.begin		;pseudo-random value for mktemp

	cseg
	public	_Uorg_,_Uend_,_Corg_

	public	.begin
	entry	.begin
.begin	cld
	lda	$E000		;check basic type
	cmp	#$20		;is it integer?
	bne	chkap		;no, check applesoft
	lda	$4C		;get integer HIMEM
	ldx	$4D
	bne	put
chkap	lda	$73		;get applesoft HIMEM
	ldx	$74
put
	sec
	sbc	#6
	sta	SP		;save in stack pointer
	sta	_End_
	bcs	.1
	dex
.1
	stx	SP+1
	stx	_End_+1
	ldy	#5
	lda	#0
.2
	sta	(SP),Y
	dey
	bpl	.2
	lda	#<_Uorg_	;clear out bss space
	sta	VAL
	lda	#>_Uorg_
	sta	VAL+1
	ldy	#0
loop	tya
	sta	(VAL),Y
	inc	VAL
	bne	skip
	inc	VAL+1
skip	lda	VAL
	cmp	#<_Uend_
	bne	loop
	lda	VAL+1
	cmp	#>_Uend_
	bne	loop
	lda	MEMRY		;set end of program for alloc routines
	sta	_Top_
	sta	_mbot_
	lda	MEMRY+1
	sta	_Top_+1
	sta	_mbot_+1
	lda	#<acc		;init pointers for floating point registers
	sta	ACC
	lda	#>acc
	sta	ACC+1
	lda	#<sec
	sta	SEC
	lda	#>sec
	sta	SEC+1
	lda	#<_devinfo_
	sta	_dev_info_
	lda	#>_devinfo_
	sta	_dev_info_+1
	lda	#<_filtab_
	sta	_fil_tab_
	lda	#>_filtab_
	sta	_fil_tab_+1
	jsr	main_
	ldy	#0
	tya
	sta	(SP),Y
	iny
	sta	(SP),Y
	jsr	exit_
	brk
;
	public	main_
	public	exit_

	dseg
	global	acc,14		;space reserved for floating point registers
	global	sec,14
*

d33roota.c
#define NULL (char *) 0
#define BUFSIZ 80
static char buf[BUFSIZ];

_cmdline()
{
	register char *bp=buf;
	register int i=1;
	register int c;
	register int argc=1;
	char *argv[20];
	int cnt;

	argv[0] = "";
	write(1,"\ncmd? ",6);
	if ((cnt=read(0,buf,BUFSIZ)) <=0){
		argv[1]=NULL;
		return main(argc, argv);
	}
	buf[cnt-1]=0;

	while (*bp){
		while ((c=*bp) && (c==' ' || c=='\t'))
			++bp;
		if (!*bp)
			break;
		argv[i++] = bp;
		++argc;
		while ((c=*++bp) && c != ' ' && c != '\t')
			;
		*bp++ = 0;
	}
	argv[i] = NULL;
	return main(argc, argv);
}
#asm
	instxt	<zpage.h>

	global	_Top_,2
	global	_mbot_,2
	global	_dev_info_,2
	global	_devinfo_,0
	global	_fil_tab_,2
	global	_filtab_,0
	global	errno_,2

	dseg
	public _DSLOT_
	public _DDRIVE_
	public _DVOLUME_
_DSLOT_	fdb	6	default slot no=6
_DDRIVE_	fcb	1	default drive no=1
_DVOLUME_	fdb	0	default volume no = 0

	global _SLOT_,2
	global _DRIVE_,2
	global _VOLUME_,2

	global _NAME_,30

	dseg
	public	MEMRY
MEMRY	rmb	2
	public	_Stksiz_
_Stksiz_
	fdb	$0800		;default stack size is 2K
	public	_End_
_End_
	fdb	$0001		;force into inited data space

	public	_main_
_main_	fdb	.begin	;pseudo-random value for mktemp

	cseg
	public	_Uorg_,_Uend_,_Corg_

	public	.begin
	entry	.begin
.begin	cld
	lda	$E000		;check basic type
	cmp	#$20		;is it integer?
	bne	chkap		;no, check applesoft
	lda	$4C		;get integer HIMEM
	ldx	$4D
	bne	put
chkap	lda	$73		;get applesoft HIMEM
	ldx	$74
put
	sec
	sbc	#6
	sta	SP		;save in stack pointer
	sta	_End_
	bcs	.1x
	dex
.1x
	stx	SP+1
	stx	_End_+1
	ldy	#5
	lda	#0
.2x
	sta	(SP),Y
	dey
	bpl	.2x
	lda	#<_Uorg_	;clear out bss space
	sta	VAL
	lda	#>_Uorg_
	sta	VAL+1
	ldy	#0
loop	tya
	sta	(VAL),Y
	inc	VAL
	bne	skip
	inc	VAL+1
skip	lda	VAL
	cmp	#<_Uend_
	bne	loop
	lda	VAL+1
	cmp	#>_Uend_
	bne	loop
	lda	MEMRY		;set end of program for alloc routines
	sta	_Top_
	sta	_mbot_
	lda	MEMRY+1
	sta	_Top_+1
	sta	_mbot_+1
	lda	#<acc		;init pointers for floating point registers
	sta	ACC
	lda	#>acc
	sta	ACC+1
	lda	#<sec
	sta	SEC
	lda	#>sec
	sta	SEC+1
	lda	#<_devinfo_
	sta	_dev_info_
	lda	#>_devinfo_
	sta	_dev_info_+1
	lda	#<_filtab_
	sta	_fil_tab_
	lda	#>_filtab_
	sta	_fil_tab_+1
	jsr	_cmdline_
	ldy	#0
	tya
	sta	(SP),Y
	iny
	sta	(SP),Y
	jsr	exit_
	brk
;
	public	_cmdline_
	public	exit_

	dseg
	global	acc,14		;space reserved for floating point registers
	global	sec,14
*
#endasm
d33roots.a65
*:ts=8
*
* Copyright (C) 1982,83,84,85 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

	global	_Top_,2
	global	_mbot_,2
	global	_dev_info_,2
	global	_devinfo_,0
	global	_fil_tab_,2
	global	_filtab_,0
	global	errno_,2

	dseg
	public _DSLOT_
	public _DDRIVE_
	public _DVOLUME_
_DSLOT_	fdb	6	default slot no=6
_DDRIVE_	fcb	1	default drive no=1
_DVOLUME_	fdb	0	default volume no = 0

	global _SLOT_,2
	global _DRIVE_,2
	global _VOLUME_,2

	global _NAME_,30

	dseg
	public	MEMRY
MEMRY	rmb	2
	public	_Stksiz_
_Stksiz_
	fdb	$0800		;default stack size is 2K
	public	_End_
_End_
	fdb	$0001		;force into inited data space

	public	_main_
_main_	fdb	.begin	;pseudo-random value for mktemp

	cseg
	public	_Uorg_,_Uend_,_Corg_

	public	.begin
	entry	.begin
.begin	cld
	lda	SP	
	ldx	SP+1
	sec
	sbc	#2
	sta	SP
	sta	_End_
	bcs	.1
	dex
.1
	stx	_End_+1
	ldy	#1
	lda	#0
	sta	(SP),y
	dey
	sta	(SP),Y
	lda	#<_Uorg_	;clear out bss space
	sta	VAL
	lda	#>_Uorg_
	sta	VAL+1
	ldy	#0
loop	tya
	sta	(VAL),Y
	inc	VAL
	bne	skip
	inc	VAL+1
skip	lda	VAL
	cmp	#<_Uend_
	bne	loop
	lda	VAL+1
	cmp	#>_Uend_
	bne	loop
	lda	MEMRY		;set end of program for alloc routines
	sta	_Top_
	sta	_mbot_
	lda	MEMRY+1
	sta	_Top_+1
	sta	_mbot_+1
	lda	#<acc		;init pointers for floating point registers
	sta	ACC
	lda	#>acc
	sta	ACC+1
	lda	#<sec
	sta	SEC
	lda	#>sec
	sta	SEC+1

	lda	#<_devinfo_
	sta	_dev_info_
	lda	#>_devinfo_
	sta	_dev_info_+1
	lda	#<_filtab_
	sta	_fil_tab_
	lda	#>_filtab_
	sta	_fil_tab_+1
	jsr	main_
	ldy	#0
	tya
	sta	(SP),Y
	iny
	sta	(SP),Y
	jsr	exit_
	brk
;
	public	main_
	public	exit_

	dseg
	global	acc,14		;space reserved for floating point registers
	global	sec,14
*

d33exit.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<dos33.h>

static
noper()
{
	return(0);
}

int (*cls_)() = noper;

exit(n)
int n;
{
	register unsigned i;

	(*cls_)();
	for (i=0;i<MAXFILES;i++)
		if (_fil_tab[i].unit)
			close(i);     /* close all remaining "unbuffered" streams */
	_exit(n);
}
d33exit2.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */

_exit(n)
{
	(*(int *)0x3cb)=n;
	(*((void (*)())0x03d0))();		/* DOS warm boot */
}

d33open.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<fcntl.h>
#include	<dos33.h>
#include	<errno.h>
#include	<sgtty.h>
#include	<device.h>

#define EBADNAME 0x40	/* ProDOS error code for bad file name */

creat(name, mode)
char *name;
{
	return open(name, O_WRONLY|O_TRUNC|O_CREAT, mode);
}

open(uname, flags, mode)
char *uname;
{
	register int dev, err, fd;
	register struct _fil_buf *fb;
	register char *iobuf;
	register struct _name_dev *dp;
	int mflg = 0;
	struct _params *p, *_get_paramlist();
	struct _buffers *b, *_get_buf();
	
	for (fb=_fil_tab;fb<_fil_tab+MAXFILES;fb++)
		if (fb->unit == 0)
			goto found;
	errno = EMFILE;
	return(-1);
found:
	fb->flags = flags & 0x03;
	fd = fb - _fil_tab;

	for (dp=&_dev_info->dev_con;dp<=&_dev_info->dev_ser;dp++) {
		if (strequ(uname, dp->dev_nam) == 0) {
			dev = dp->dev_num;
			goto gotdev;
		}
	}
	if (uname[3] == 0 && uname[2] == ':' && toupper(uname[0]) == 'S') {
		dev = uname[1] - '0';
gotdev:
		if ((dev&0x40) == 0)
			_slot_open(&_dev_info->slots[dev&7]);
		fb->unit = dev | 0x80;
		return(fd);
	}
	/* open a file: */
	p = _get_paramlist();
	if (_get_name(uname,p) < 0 ){
		errno = EBADNAME;
		return -1;
	}
	if ((b = _get_buf(p)) == 0){
		errno= EMFILE;
		return -1;
	}
	p->p_cmd = D33_OPEN; /* open file without creating it */
	p->p_record = 0;
	_dos(1);
	if (err = p->p_return) { /* if open w/o create failed... */
		if (err != 6) {/* only valid error is 'file doesn't exist' */
	xerr:
			_free_buf(b);
			errno = _errxlate(err);
			return(-1);
		}
		/* file doesn't exist. if create not requested, take error exit */
		if ((flags&O_CREAT) == 0) {
			err = ENOENT;
			goto xerr;
		}
		p->p_cmd=D33_OPEN; /* create file & open it */
		p->p_record = 0;
		p->p_range = p->p_range & 0xff | mode<<8; /* set file type */
		_dos(0);
		if (err = p->p_return && err != 6) /* if create & open fails, give up */
			goto xerr;
	} else { /* open w/o create succeeded */
		/* if open should fail if file already exists, take error exit */
		if ((flags&(O_CREAT|O_EXCL)) == (O_CREAT|O_EXCL)) {
			p->p_cmd=D33_CLOSE;
			_dos(1);
			_free_buf(b);
			errno = EEXIST;
			return -1;
		}
		/* if truncation requested, delete, close, create*/
		if (flags & O_TRUNC){ 
			p->p_cmd=D33_CLOSE;
			_dos(1);
			p->p_cmd = D33_DELETE;
			_dos(1);
			p->p_cmd = D33_OPEN;
			p->p_record = 0; /* variable length records */
			p->p_range = p->p_range & 0xff | mode<<8; /* set file type */
			_dos(0);
			if ((err=p->p_return) && err != 6)
				goto xerr;
		}
	}

	/* position file: */
	if (flags & O_APPEND)
		lseek(fd, 0L, 2);
	else {
		p->p_cmd = D33_POSITION;
		p->p_record = 0;
		p->p_offset = 0;
		p->p_range = 0;
		p->p_work = (char *) b->b_work;
		_dos(1);
	}

	fb->unit = 1;	/* set 'file descriptor' flag */
	fb->iob = b;
	return fd;
}

d33read.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<dos33.h>
#include	<fcntl.h>
#include	<errno.h>
#include	<sgtty.h>
#include	<device.h>

read (fd, buf, cnt)
register int fd, cnt;
register char *buf;
{
	register int ret;
	register int offset, record;
	register struct _buffers *b;
	register struct _params *p, *_get_paramlist();
	register struct _wrkbuf *wrk;
	register struct _fil_buf *fp;

	fp = _fil_tab+fd;
	if (fd < 0 || fd >= MAXFILES || fp->unit == 0 || fp->flags == O_WRONLY) {
		errno = EBADF;
		return(-1);
	}
	if ((fp->unit)&0x80) {
		if (fp->unit&0x40)
			return(_kb_get(buf, cnt));
		return(_dev_read(&_dev_info->slots[fp->unit&7], buf, cnt));
	}
	/* file read: */
	b = fp->iob;
	wrk = b->b_work;
	p = _get_paramlist();
	p->p_cmd = 3;
	p->p_sub = 2;
	offset = wrk->w_offset;
	record = wrk->w_record;
	p->p_range = cnt;
	p->p_addr = buf;
	p->p_work = (char *)wrk;
	p->p_tslist = b->b_tslist;
	p->p_data = b->b_data;
	_dos(1);
#ifdef DEBUG
	printf("in read. rc=%d\n",p->p_return);
#endif
	if ((ret = p->p_return) && ret != 5){
		errno = _errxlate(ret);
		return -1;
	}
	ret = ((wrk->w_record - record)<<8) + wrk->w_offset - offset;
#ifdef DEBUG
	printf("in read. br=%d er=%d bo=%d eo=%d ret=%d\n",record, wrk->w_record,
		offset, wrk->w_offset,ret);
#endif
	if (ret == 0)
		return(0);
	if ((wrk->w_ftype&0x7f) == 0) {
		cnt = strlen(buf);
#ifdef DEBUG
		printf("in read. cnt=%d\n",cnt);
#endif
		if (cnt < ret) {
			lseek(fd, (long) (cnt - ret), 1);
			return(cnt);
		}
	}
	return(ret);
}

_dev_read(s, buf, cnt)
struct _slot_dev *s;
unsigned char *buf;
{
	int i;

	for (i=0;i<cnt;i++)
		if ((*buf++ = _slot_read(s)) < 0)
			break;
	return(i);
}

d33write.c
/* Copyright (C) 1984 by Manx Software Systems */
#include	<dos33.h>
#include	<fcntl.h>
#include	<errno.h>
#include	<sgtty.h>
#include	<device.h>

write (fd, buf, cnt)
register int fd, cnt;
register char *buf;
{
	register unsigned offset, record;
	register int ret;
	register struct _params *p, *_get_paramlist();
	register struct _buffers *b;
	register struct _wrkbuf *wrk;
	register int err;
	register struct _fil_buf *fp;

	fp = _fil_tab+fd;
	if (fd < 0 || fd >= MAXFILES || fp->unit == 0 || fp->flags == O_RDONLY) {
		errno = EBADF;
		return(-1);
	}
	if (cnt == 0)
		return(0);
	if (fp->unit & 0x80) {
		if (fp->unit & 0x40)
			return(_kb_put(buf, cnt));
		return(_dev_write(&_dev_info->slots[fp->unit&7], buf, cnt));
	}
	/* file write: */
	b = fp->iob;
	wrk = b->b_work;
	p = _get_paramlist();
	p->p_cmd = 4;
	p->p_sub = 2;
	offset = wrk->w_offset;
	record = wrk->w_record;
	p->p_range = cnt - 1;
	p->p_addr = buf;
	p->p_work = (char *)wrk;
	p->p_tslist = b->b_tslist;
	p->p_data = b->b_data;
	_dos(1);
	if (ret = p->p_return) {
		errno = _errxlate(ret);
		return -1;
	}
	return(((wrk->w_record - record)<<8) + wrk->w_offset - offset);
}

_dev_write(s, buf, cnt)
char *buf;
{
	int i = cnt;

	while (cnt--)
		_slot_write(s, *buf++);
	return(i);
}

d33lseek.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<errno.h>
#include	<dos33.h>

long
lseek (fd, pos, how)
long pos;
{
	register int err;
	register struct _fil_buf *fp;
	register struct _params *p;
	register struct _buffers *b;
	register struct _wrkbuf *w;
	long off;

	fp = _fil_tab+fd;
	if (fd < 0 || fd > MAXFILES || fp->unit == 0) {
		errno = EBADF;
		return(-1L);
	}
	if (fp->unit & 0x80){
		errno= EACCES;
		return -1L;
	}
	b = fp->iob;
	w = b->b_work;
	p = _get_paramlist();
	p->p_cmd = D33_POSITION;
	off = w->w_record;
	off = (off << 8) + w->w_offset;
	if (how == 1)
		pos += off;
	p->p_record = pos >> 8;
	p->p_offset = pos & 0xff;
	p->p_work = (char *) b->b_work;
	_dos(1);
	if (p->p_return){
		errno = _errxlate(p->p_return);
		return -1L;
	}
	return pos;
}
d33close.c
/* Copyright (C) 1985 by Manx Software Systems */

#include	<dos33.h>
#include	<errno.h>

close (fd)
{
	register struct _fil_buf *fp;
	register int err;
	struct _params *_get_paramlist(), *p;
	struct _buffers *b;

	fp = _fil_tab+fd;
	if (fd >= MAXFILES || fp->unit == 0) {
		errno = EBADF;
		return(-1);
	}

	err = fp->unit;
	fp->unit = 0; /* free filbuf entry */
	if (err&0x80) /* device close: */
		return 0;
	/* file close: */
	p = _get_paramlist();
	b = fp->iob;
	p->p_cmd = D33_CLOSE;
	p->p_work = (char *) b->b_work;
	p = _get_paramlist();
	p->p_tslist = b->b_tslist;
	p->p_data = b->b_data;
	_dos(1);
	_free_buf(b);
	if (err = p->p_return){
		errno=_errxlate(err);
		return -1;
	}
	return 0;
}

d33renam.c
/* Copyright (C) 1986 by Manx Software Systems, Inc. */
#include <errno.h>
#include <sgtty.h>
#include <device.h>
#include <dos33.h>

#define EBADNAME 0x40	/* ProDOS error code for bad file name */

rename(old, new)
char *old, *new;
{
	register struct _params *p, *_get_paramlist();
	register struct _buffers *b, *_get_buf();

	char name[30];

	if (_isdev(old) || _isdev(new)){
badname:
		errno = EBADNAME;
		return -1;
	}
	p = _get_paramlist();
	p->p_cmd = D33_RENAME;
	if (_get_name(new,p))
		goto badname;
	strncpy(name, _NAME, 30);
	*((char **)&p->p_record) = name;
	if (_get_name(old, p))
		goto badname;
	if ((b = _get_buf(p)) == 0){
		errno = EMFILE;
		return(-1);
	}
	_dos(1);
	_free_buf(b);
	if (p->p_return){
		errno = _errxlate(p->p_return);
		return -1;
	}
	return 0;
}

d33unlnk.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<errno.h>
#include <dos33.h>

#define EBADNAME 0x40	/* ProDOS error code for bad file name */

unlink(name)
char *name;
{
	register struct _params *p;
	register struct _buffers *b;

	if (_isdev(name)){
badname:
		errno = EBADNAME;
		return -1;
	}
	p = _get_paramlist();
	p->p_cmd = D33_DELETE;
	if (_get_name(name, p))
		goto badname;
	if ((b = _get_buf(p)) == 0){
		errno = EMFILE;
		return(-1);
	}
	_dos(1);
	_free_buf(b);
	if (p->p_return){
		errno = _errxlate(p->p_return);
		return -1;
	}
	return 0;
}
d33acces.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<dos33.h>
#include	<errno.h>
#define EBADNAME 0x40	/* ProDOS error code for bad file name */
#define BINARY 4

access(file, mode)
char *file;
{
	register struct _params *p;
	register struct _buffers *b;
	register int filetype;
	int err;

	if (_isdev(file))
		return 0;
	p = _get_paramlist();
	if (_get_name(file,p) < 0 ){
		errno = EBADNAME;
		return -1;
	}
	if ((b = _get_buf(p)) == 0){
		errno= EMFILE;
		return -1;
	}
	p->p_cmd = D33_OPEN; /* open file without creating it */
	p->p_record = 0;
	_dos(1);
	if (err=p->p_return) { /* if open w/o create failed... */
		_free_buf(b);
		errno = _errxlate(err);
		return -1;
	}
	filetype=p->p_range>>8;
	p->p_cmd = D33_CLOSE;
	_dos(1);
	_free_buf(b);
	switch(mode) {
	case 0:
	case 4:
		return(0);
	case 1:
		if ((filetype&0x7f)==BINARY)
			return 0;
		errno = EACCES;
		return(-1);
	case 2:
		if ((filetype & 0x80) == 0)
			return(0);
		errno = EACCES;
		return(-1);
	}
	errno = EACCES;
	return(-1);
}

isdev.c
#include <sgtty.h>
#include <device.h>

_isdev(name)
char *name;
{
	register struct _name_dev *dp;

	for (dp=&_dev_info->dev_con;dp<=&_dev_info->dev_ser;dp++) 
		if (strequ(name, dp->dev_nam) == 0) 
			return -1;
	if (name[3] == 0 && name[2] == ':' && toupper(name[0]) == 'S') 
		return -1;
	return 0;
}
dos.a65
*
* Copyright (c) 1982 by Manx Software Systems
* Copyright (c) 1982 by Jim Goodnow II
*
*		:tab=8
	instxt	<zpage.h>
*
*
	public	_get_paramlist_
_get_paramlist_	jsr	$3DC
	sty	R0
	sta	R0+1
	rts
*
*
	public	_dos_
_dos_	ldy	#2
	lda	(SP),Y
	tax
	jmp	$3D6
*
getname.c
/*	Copyright (c) 1986 by Manx Software Systems	*/

#include <dos33.h>

_get_name(name, p)
char *name;
register struct _params *p;
{
	register int i, c;
	register char *cp;

	if (_parse(name) < 0 || (_NAME[0]&0x7f) == ' ')
		return(-1);

	p->p_offset = (_DRIVE << 8) | _VOLUME;
	p->p_range = (p->p_range & 0xff00) | _SLOT;
	p->p_addr = _NAME;
	return(0);
}

/*
 *	This routine parses a given name for the name, drive, slot and volume
 *		parameters. It puts the result in the global variables SLOT, DRIVE,
 *		VOLUME and NAME. These values default to the current data device.
 */

_parse(name)
register char *name;
{
	register int i, c;
	register char *cp;
	char buf[60];
	int code;

	if (*name == 0)
		return(-1);
	_SLOT = _DSLOT;
	_DRIVE = _DDRIVE;
	_VOLUME = _DVOLUME;

	/* get file name: */
	for (cp=_NAME;(c= *name) && c != ',';++cp, ++name)
		*cp = toupper(c) | 0x80;
	for (;cp< _NAME+30;cp++)
		*cp = ' ' | 0x80;

	/* get drive, slot, volume numbers: */
	while (*name++) {
		code = *name++;
		for (i=0; (c = *name) && c >= '0' && c <= '9';name++)
			i = i*10 + c-'0';
		if (c && c != ',')
			return -1;
		switch (toupper(code)){
		case 'S':
			if (i<1 || i > 7)
				return -1;
			_SLOT = i;
			break;
		case 'D':
			if (i < 1 || i > 2)
				return -1;
			_DRIVE = i;
			break;
		case 'V':
			if (i<0 || i>254)
				return -1;
			*(int *)0xaa66 = _VOLUME = i;
			break;
		default:
			return -1;
		}
	}
	return(0);
}
getbuf.c
/*	Copyright (c) 1986 by Manx Software Systems	*/

#include	<dos33.h>

struct _buffers *
_get_buf(p)
register struct _params *p;
{
	register struct _buffers *b, *remember;
	register struct _wrkbuf *w;
	register int sl, dr, vo, *ip;

	remember = 0;
	sl = p->p_range & 0xff;
	dr = p->p_offset >> 8;
	vo = ~(p->p_offset & 0xff);
	ip = (int *)0x3d1;
	ip = (int *)(*ip & 0xff00);
	b = (struct _buffers *) *ip;
	while (b) {
		w = b->b_work;
		if (b->b_name[0] && strncmp(p->p_addr, b->b_name, 30) == 0 &&
				w->w_slot == sl && w->w_drive == dr &&
				(vo == ~0 || vo == w->w_volume) )
			return(0);
		if (remember == 0 && b->b_name[0] == 0)
			remember = b;
		b = b->b_next;
	}
	if (remember == 0)
		return(0);
	b = remember;
	p->p_work = (char *) b->b_work;
	p->p_tslist = b->b_tslist;
	p->p_data = b->b_data;
	strncpy(b->b_name, p->p_addr, 30);
	return(b);
}

freebuf.c
/*	Copyright (c) 1986 by Manx Software Systems	*/

#include	<dos33.h>

_free_buf(b)
register struct _buffers *b;
{
	b->b_name[0] = 0;
}

errxlate.c
#include <errno.h>

static int errcodes[]={
	0,				/* 0 = no error */
	EINVAL,			/* 1 = not used */
	EINVAL,			/* 2 = bad call type */
	EINVAL,			/* 3 = bad sub call type */
	0x2b,			/* 4 = disk write protected */
	0x4c,			/* 5 = end of data */
	ENOENT,			/* 6 = file exists */
	0x45,			/* 7 = volume mismatch */
	0x27,			/* 8 = i/o error */
	0x48,			/* 9 = disk full */
	EACCES			/* 10 = invalid operation */
};
int _d33errno;

_errxlate(err)
{
	_d33errno = err;
	return  errcodes[err];
}
